#!/bin/sh
########################################################################
########################################################################
#                                                                      #
#  This script is used by the daemon for catering device-initiated     #
#  scan requests.                                                      #
#                                                                      #
#  This script will display save-file dialog for the user to select    #
#  where scanner PDF output will be saved to. After a file is selected #
#  scanimage will be invoked with the parameters given to this script  #
#                                                                      #
#  Requires the following scripts:                                     #
#  (refer to PATHS section for actual filepaths)                       #
#      scan save script                                                #
#                                                                      #
#  Parameters: scanimage parameters                                    #
########################################################################

## PATHS ##

# leave this blank if the shell or C system() is going to be used
# use full path if an exec function is to be used
script_path="./"
if [ -n "${SCAN_SCRIPT_PATH}" ]; then
        script_path="${SCAN_SCRIPT_PATH}"
fi

# Path to save file dialog script
save_script="${script_path}scanSave.sh"


## ENV VARIABLES ##

# Set env variable for default output filename
export SCAN_DEFAULT_FILENAME="$HOME/"`date +"%Y-%m-%d_%H:%M:%S"`".pnm"

# Set env variable for save dialog file filter
export SCAN_SAVE_DIALOG_FILE_FILTER="*.PNM *.pnm"


# Execute save script
${save_script} "$@" &


